/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_572;
import net.minecraft.class_607;
import net.minecraft.class_918;
import slimeknights.mantle.data.fabric.IdentifiableISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.tools.client.ArmorModelHelper;

public class SlimeskullArmorModel
extends class_3879 {
    private static final SlimeskullArmorModel INSTANCE = new SlimeskullArmorModel();
    public static final IdentifiableISafeManagerReloadListener RELOAD_LISTENER = new IdentifiableISafeManagerReloadListener(TConstruct.getResource("slime_skull_cache")){

        @Override
        public void onReloadSafe(class_3300 manager) {
            HEAD_MODELS = null;
        }
    };
    @Nullable
    private class_572<?> base;
    @Nullable
    private class_2960 headTexture;
    @Nullable
    private class_5598 headModel;
    private boolean hasGlint = false;
    private static final Map<MaterialId, Function<class_5599, ? extends class_5598>> HEAD_MODEL_FACTORIES = new HashMap<MaterialId, Function<class_5599, ? extends class_5598>>();
    private static final Map<MaterialId, class_2960> HEAD_TEXTURES = new HashMap<MaterialId, class_2960>();
    private static Map<MaterialId, class_5598> HEAD_MODELS;

    public static class_3879 getModel(class_1799 stack, class_572<?> baseModel) {
        INSTANCE.setup(baseModel, stack);
        return INSTANCE;
    }

    private SlimeskullArmorModel() {
        super(class_1921::method_23578);
    }

    public void method_2828(class_4587 matrixStackIn, class_4588 vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null) {
            matrixStackIn.method_22903();
            matrixStackIn.method_22904(0.0, this.base.field_3448 ? -0.015 : -0.02, 0.0);
            matrixStackIn.method_22905(1.01f, 1.1f, 1.01f);
            this.base.method_2828(matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStackIn.method_22909();
            if (this.headModel != null && this.headTexture != null && ArmorModelHelper.buffer != null) {
                class_4588 headBuilder = class_918.method_27952((class_4597)ArmorModelHelper.buffer, (class_1921)class_1921.method_28116((class_2960)this.headTexture), (boolean)false, (boolean)this.hasGlint);
                matrixStackIn.method_22903();
                if (this.base.field_3400) {
                    matrixStackIn.method_46416(0.0f, this.base.field_3398.field_3656 / 16.0f, 0.0f);
                }
                if (this.base.field_3448) {
                    matrixStackIn.method_22905(0.85f, 0.85f, 0.85f);
                    matrixStackIn.method_22904(0.0, 1.0, 0.0);
                } else {
                    matrixStackIn.method_22905(1.115f, 1.115f, 1.115f);
                }
                this.headModel.method_2821(0.0f, this.base.field_3398.field_3675 * 180.0f / (float)Math.PI, this.base.field_3398.field_3654 * 180.0f / (float)Math.PI);
                this.headModel.method_2828(matrixStackIn, headBuilder, packedLightIn, packedOverlayIn, red, green * 0.5f, blue, alpha * 0.8f);
                matrixStackIn.method_22909();
            }
        }
    }

    private void setup(class_572<?> base, class_1799 stack) {
        this.base = base;
        this.hasGlint = stack.method_7958();
        MaterialId materialId = MaterialIdNBT.from(stack).getMaterial(0).getId();
        if (!materialId.equals(IMaterial.UNKNOWN_ID)) {
            class_5598 model = SlimeskullArmorModel.getHeadModel(materialId);
            class_2960 texture = HEAD_TEXTURES.get(materialId);
            if (model != null && texture != null) {
                this.headModel = model;
                this.headTexture = texture;
                return;
            }
        }
        this.headTexture = null;
        this.headModel = null;
    }

    public static void registerHeadModel(MaterialId materialId, class_5601 headModel, class_2960 texture) {
        SlimeskullArmorModel.registerHeadModel(materialId, (class_5599 modelSet) -> new class_607(modelSet.method_32072(headModel)), texture);
    }

    public static void registerHeadModel(MaterialId materialId, Function<class_5599, ? extends class_5598> headFunction, class_2960 texture) {
        if (HEAD_MODEL_FACTORIES.containsKey(materialId)) {
            throw new IllegalArgumentException("Duplicate head model " + materialId);
        }
        HEAD_MODEL_FACTORIES.put(materialId, headFunction);
        HEAD_TEXTURES.put(materialId, texture);
    }

    @Nullable
    private static class_5598 getHeadModel(MaterialId materialId) {
        if (HEAD_MODELS == null) {
            class_5599 modelSet = class_310.method_1551().method_31974();
            ImmutableMap.Builder models = ImmutableMap.builder();
            for (Map.Entry<MaterialId, Function<class_5599, ? extends class_5598>> entry : HEAD_MODEL_FACTORIES.entrySet()) {
                models.put((Object)entry.getKey(), (Object)entry.getValue().apply(modelSet));
            }
            HEAD_MODELS = models.build();
        }
        return HEAD_MODELS.get(materialId);
    }
}

